UNIT TitleZ;
INTERFACE
USES
{$L-}
{$U-}
   {$LOAD MQOTP.dumpfile}
       Memtypes, QuickDraw, OSIntf, ToolIntf, PackIntf,
	 {$LOAD Globals.dumpfile}
   {$U Globals.p}  Globals;
	 {$LOAD}
{$U+}
{$SETC DebugFlg:=FALSE}

PROCEDURE Titles;
PROCEDURE MakeOptions;

IMPLEMENTATION
{$S TitlePage}
{********************************************************************************}
PROCEDURE InitChar(Who: Integer; Name,Spec: Str255; CharSex: Boolean;
					Lo,Iy,Te,Re,Du,Pr,Se,DL,Gu: Integer; FName: Str255);
VAR
  i,j,k:   Integer;
BEGIN
  CharName[Who]:=Name;
  Species[Who]:=Spec;
  Male[Who]:=CharSex;
	Loyalty[Who]:=Lo;
	Integrity[Who]:=Iy;
  Temper[Who]:=Te;
	Revenge[Who]:=Re;
	Duty[Who]:=Du;
  Pride[Who]:=Pr;
	Secret[Who]:=Se;
	DesLiked[Who]:=DL;
  Gullble[Who]:=Gu;
  Interloc[Who]:=0;
  CharLocn[Who]:=Who;
  DoorLock[Who]:=FALSE;
  DlogIndx[Who]:=0;
	GuestFlg[Who]:=FALSE;
	HelloFlg[Who]:=TRUE;
	Fiance[Who]:=FName;
  IF Who<>Player THEN
    BEGIN
      Sentence[Who,SubjectA]:=Who;
      Sentence[Who,VerbA]:=WPause;
      ExecTime[Who]:=479+Who;
    END;
END;
{********************************************************************************}
FUNCTION YourOpen(Filename: Str255): Integer;
VAR
  Error: OSErr;
  LocalNum: Integer;
  NameStr:  Str255;
  volName:	StringPtr;
  WDRefNum:	Integer;
  volNamePtr:	StringPtr;
BEGIN
  Error:=GetVol(NIL,WDRefNum);
  Error:=FSOpen(FileName,0,LocalNum);
  IF Error<>0 THEN
	BEGIN
	  ClearRect(100,100,512,120);
	  TextFont(0); TextSize(12);
	  MoveTo(102,116); DrawString('Disk Problem');
	  MyWrite(Error); DrawString(FileName);
	  REPEAT UNTIL Button;
	  ExitToShell;
	END;
  YourOpen:=LocalNum;
END;
{********************************************************************************}
PROCEDURE ReadFaces;
CONST
  headerSize = 512;
  BufSize = 512;
  srcBlocks = 8;
TYPE
  diskBlock = packed array [1..512] OF QDbyte;
VAR
  refNum,scanline,srcSize:    Integer;
  i,j,k,y,Row,Column:	      	Integer;
  showRect,lineRect,FaceRect:	Rect;
  dstBMap,tempBMap:	      		BitMap;
  dstBits:		      					packed array [1..72] of byte;
  tempBits:		      					ARRAY [1..8000] OF Integer;
  srcPtr,dstPtr,MyPtr:	      Ptr;
  Count:		      						LongInt;
  error:		      						OSErr;
  srcBuf:		      						ARRAY [1..srcBlocks] OF diskBlock;
  StrHandle:		      				StringHandle;
  TempStr:			  						Str255;
BEGIN
  dstBMap.rowBytes:=64;
  dstBMap.baseAddr:=@dstBits;
  SetRect(dstBMap.bounds,0,0,512,1);
  dstPtr:=pointer(dstBMap.baseAddr);
  tempBMap.rowBytes:=64;
  tempBMap.baseAddr:=@tempBits;
  SetRect(tempBMap.bounds,0,0,512,256);
  FOR i:=1 TO 8 DO
    BEGIN
      Face[i].rowBytes:=20;
      Face[i].baseAddr:=NewPtr(3200);
      SetRect(Face[i].bounds,0,0,160,160);
    END;
	RefNum:=YourOpen('NewFaces');
  Count:=headerSize;
  error:=FSRead(refNum,Count,@srcBuf);
  srcSize:=srcBlocks*512;
  Count:=srcSize;
  error:=FSRead(refNum,Count,@srcBuf);
  Count:=Count-512;
  srcPtr:=@srcBuf;
  SetRect(lineRect,0,0,512,1);
	FOR Row:=0 TO 2 DO
	  BEGIN
  		SetRect(showRect,0,0,512,1);
			FOR Scanline:=1 to 160 do
				BEGIN
					UnpackBits(srcPtr,dstPtr,72);
					CopyBits(dstBMap,tempBMap,lineRect,showRect,srcCopy,NIL);
					dstPtr:=pointer(dstBMap.baseAddr);
					OffsetRect(showRect,0,1);
					IF ORD(srcPtr)>(ORD(@srcBuf)+srcSize-512) THEN
						BEGIN
							srcBuf[1]:=srcBuf[srcBlocks];
							error:=FSRead(refNum,Count,@srcBuf[2]);
							srcPtr:=pointer(ord(srcPtr)+512-srcSize);
						END;
				END;
			FOR Column:=0 To 2 DO IF ((Column+3*Row+1)<=8) THEN
				BEGIN
					SetRect(FaceRect,160*Column,0,160*Column+160,160);
					CopyBits(tempBMap,Face[Column+3*Row+1],FaceRect,StdRect3,srcCopy,NIL);
				END;
		END;
  error:=FSClose(refnum);
END;
{********************************************************************************}
PROCEDURE ReadWords;
CONST
  headerSize = 512;
  BufSize = 512;
  srcBlocks = 8;
TYPE
  diskBlock = packed array [1..512] OF QDbyte;
VAR
  refNum,scanline,srcSize:    Integer;
  i,j,k,y,Row,Column:	      Integer;
  showRect,lineRect:	      Rect;
  dstBMap,tempBMap:	          BitMap;
  dstBits:		              packed array [1..72] of byte;
  tempBits:		              ARRAY [1..8192] OF Integer;
  srcPtr,dstPtr,MyPtr:	      Ptr;
  Count:		              LongInt;
  error:		              OSErr;
  srcBuf:		              ARRAY [1..srcBlocks] OF diskBlock;
  StrHandle:		          StringHandle;
BEGIN
  dstBMap.rowBytes:=64;
  dstBMap.baseAddr:=@dstBits;
  SetRect(dstBMap.bounds,0,0,512,1);
  dstPtr:=pointer(dstBMap.baseAddr);
  tempBMap.rowBytes:=64;
  tempBMap.baseAddr:=@tempBits;
  SetRect(tempBMap.bounds,0,0,512,256);
  FOR i:=1 TO NumWords DO
    BEGIN
      WordIcon[i].rowBytes:=4;
      WordIcon[i].baseAddr:=NewPtr(128);
      SetRect(WordIcon[i].bounds,0,0,32,32);
      WordText[i].rowBytes:=4;
      WordText[i].baseAddr:=NewPtr(128);
      SetRect(WordText[i].bounds,0,0,32,32);
    END;

  RefNum:=YourOpen('WordIcons');
  Count:=headerSize;
  error:=FSRead(refNum,Count,@srcBuf);
  srcSize:=srcBlocks*512;
  Count:=srcSize;
  error:=FSRead(refNum,Count,@srcBuf);
  Count:=Count-512;
  srcPtr:=@srcBuf;
  SetRect(showRect,0,0,512,1);
  SetRect(lineRect,0,0,512,1);
  FOR Scanline:=1 to 256 do
    BEGIN
      UnpackBits(srcPtr,dstPtr,72);
      CopyBits(dstBMap,tempBMap,lineRect,showRect,srcCopy,NIL);
      dstPtr:=pointer(dstBMap.baseAddr);
      OffsetRect(showRect,0,1);
      IF ORD(srcPtr)>(ORD(@srcBuf)+srcSize-512) THEN
        BEGIN
          srcBuf[1]:=srcBuf[srcBlocks];
          error:=FSRead(refNum,Count,@srcBuf[2]);
          srcPtr:=pointer(ord(srcPtr)+512-srcSize);
        END;
    END;
  error:=FSClose(refnum);
  SetRect(lineRect,0,0,512,256);
  FOR Column:=0 TO 15 DO
    BEGIN
      FOR Row:=0 To 7 DO
        BEGIN
          SetRect(lineRect,32*Column,32*Row,32*Column+32,32*Row+32);
          CopyBits(tempBMap,WordIcon[8*Column+Row+1],lineRect,StdRect1,srcCopy,NIL);
        END;
    END;
  {now read in the word texts}
  RefNum:=YourOpen('WordTexts');
  Count:=headerSize;
  error:=FSRead(refNum,Count,@srcBuf);
  srcSize:=srcBlocks*512;
  Count:=srcSize;
  error:=FSRead(refNum,Count,@srcBuf);
  Count:=Count-512;
  srcPtr:=@srcBuf;
  SetRect(showRect,0,0,512,1);
  SetRect(lineRect,0,0,512,1);
  FOR Scanline:=1 to 256 do
    BEGIN
      UnpackBits(srcPtr,dstPtr,72);
      CopyBits(dstBMap,tempBMap,lineRect,showRect,srcCopy,NIL);
      dstPtr:=pointer(dstBMap.baseAddr);
      OffsetRect(showRect,0,1);
      IF ORD(srcPtr)>(ORD(@srcBuf)+srcSize-512) THEN
        BEGIN
          srcBuf[1]:=srcBuf[srcBlocks];
          error:=FSRead(refNum,Count,@srcBuf[2]);
          srcPtr:=pointer(ord(srcPtr)+512-srcSize);
        END;
    END;
  error:=FSClose(refnum);
  SetRect(lineRect,0,0,512,256);
  FOR Column:=0 TO 15 DO
    BEGIN
      FOR Row:=0 To 7 DO
        BEGIN
          SetRect(lineRect,32*Column,32*Row,32*Column+32,32*Row+32);
          CopyBits(tempBMap,WordText[8*Column+Row+1],lineRect,StdRect1,srcCopy,NIL);
        END;
    END;

  DummyF1:=YourOpen('Connections');
  error:=SetFPos(DummyF1,1,0);
  Count:=LongInt(@DummyF1)-LongInt(@DummyF2);
  error:=FSRead(DummyF1,Count,@DummyF2);
  error:=FSClose(DummyF1);
END;
{********************************************************************************}
PROCEDURE ReadEmotions;
CONST
  headerSize = 512;
  BufSize = 512;
  srcBlocks = 8;
TYPE
  diskBlock = packed array [1..512] OF QDbyte;
VAR
  refNum,scanline,srcSize:    Integer;
  i,j,k,y,Row,Column:	      	Integer;
  showRect,lineRect,FaceRect:	Rect;
  dstBMap,tempBMap:	      		BitMap;
  dstBits:		      					packed array [1..72] of byte;
  tempBits:		      					ARRAY [1..5000] OF Integer;
  srcPtr,dstPtr,MyPtr:	      Ptr;
  Count:		      						LongInt;
  error:		      						OSErr;
  srcBuf:		      						ARRAY [1..srcBlocks] OF diskBlock;
  StrHandle:		      				StringHandle;
  TempStr:			  						Str255;
BEGIN
  dstBMap.rowBytes:=72;
  dstBMap.baseAddr:=@dstBits;
  SetRect(dstBMap.bounds,0,0,576,1);
  dstPtr:=pointer(dstBMap.baseAddr);
  tempBMap.rowBytes:=72;
  tempBMap.baseAddr:=@tempBits;
  SetRect(tempBMap.bounds,0,0,576,96);
  FOR i:=1 TO 42 DO
    BEGIN
      Emotion[i].rowBytes:=12;
      Emotion[i].baseAddr:=NewPtr(1152);
      SetRect(Emotion[i].bounds,0,0,96,96);
    END;
	RefNum:=YourOpen('EmotionFaces');
  Count:=headerSize;
  error:=FSRead(refNum,Count,@srcBuf);
  srcSize:=srcBlocks*512;
  Count:=srcSize;
  error:=FSRead(refNum,Count,@srcBuf);
  Count:=Count-512;
  srcPtr:=@srcBuf;
  SetRect(lineRect,0,0,576,1);
	FOR Row:=0 TO 6 DO
	  BEGIN
  		SetRect(showRect,0,0,576,1);
			FOR Scanline:=1 to 96 do
				BEGIN
					UnpackBits(srcPtr,dstPtr,72);
					CopyBits(dstBMap,tempBMap,lineRect,showRect,srcCopy,NIL);
					dstPtr:=pointer(dstBMap.baseAddr);
					OffsetRect(showRect,0,1);
					IF ORD(srcPtr)>(ORD(@srcBuf)+srcSize-512) THEN
						BEGIN
							srcBuf[1]:=srcBuf[srcBlocks];
							error:=FSRead(refNum,Count,@srcBuf[2]);
							srcPtr:=pointer(ord(srcPtr)+512-srcSize);
						END;
				END;
			FOR Column:=0 To 5 DO
				BEGIN
					SetRect(FaceRect,96*Column,0,96*Column+96,96);
					CopyBits(tempBMap,Emotion[Column+6*Row+1],FaceRect,StdRect4,srcCopy,NIL);
				END;
		END;
  error:=FSClose(refnum);
END;
{********************************************************************************}
{PROCEDURE ReadImages(PaintFName: Str255; NumRows,NumColumns,RectHeight,RectWidth: Integer);
ReadImages('EmoteFaces',6,5,96,96);
CONST
  headerSize = 512;
  BufSize = 512;
  srcBlocks = 8;
TYPE
  diskBlock = packed array [1..512] OF QDbyte;
VAR
  refNum,scanline,srcSize:    Integer;
  i,j,k,y,Row,Column:	      	Integer;
  showRect,lineRect,FaceRect:	Rect;
  dstBMap,tempBMap:	      		BitMap;
  dstBits:		      					packed array [1..72] of byte;
  tempBits:		      					ARRAY [1..8000] OF Integer;
  srcPtr,dstPtr,MyPtr:	      Ptr;
  Count:		      						LongInt;
  error:		      						OSErr;
  srcBuf:		      						ARRAY [1..srcBlocks] OF diskBlock;
  StrHandle:		      				StringHandle;
  TempStr:			  						Str255;
	LoclStdRect:								Rect;
BEGIN
  dstBMap.rowBytes:=64;
  dstBMap.baseAddr:=@dstBits;
  SetRect(dstBMap.bounds,0,0,512,1);
  dstPtr:=pointer(dstBMap.baseAddr);
  tempBMap.rowBytes:=64;
  tempBMap.baseAddr:=@tempBits;
  SetRect(tempBMap.bounds,0,0,512,256);
  FOR i:=1 TO 42 DO
    BEGIN
      Emotion[i].rowBytes:=12;
      Emotion[i].baseAddr:=NewPtr(1152);
      SetRect(Emotion[i].bounds,0,0,96,96);
    END;
	RefNum:=MyOpen(PaintFName);
  Count:=headerSize;
  error:=FSRead(refNum,Count,@srcBuf);
  srcSize:=srcBlocks*512;
  Count:=srcSize;
  error:=FSRead(refNum,Count,@srcBuf);
  Count:=Count-512;
  srcPtr:=@srcBuf;
  SetRect(lineRect,0,0,512,1);
	FOR Row:=0 TO NumRows DO
	  BEGIN
  		SetRect(showRect,0,0,512,1);
			FOR Scanline:=1 to RectHeight do
				BEGIN
					UnpackBits(srcPtr,dstPtr,72);
					CopyBits(dstBMap,tempBMap,lineRect,showRect,srcCopy,NIL);
					dstPtr:=pointer(dstBMap.baseAddr);
					OffsetRect(showRect,0,1);
					IF ORD(srcPtr)>(ORD(@srcBuf)+srcSize-512) THEN
						BEGIN
							srcBuf[1]:=srcBuf[srcBlocks];
							error:=FSRead(refNum,Count,@srcBuf[2]);
							srcPtr:=pointer(ord(srcPtr)+512-srcSize);
						END;
				END;
			SetRect(LoclStdRect,0,0,RectWidth,RectHeight);
			FOR Column:=0 To NumColumns DO
				BEGIN
					SetRect(FaceRect,RectWidth*Column,0,RectWidth*(Column+1),RectHeight);
					CopyBits(tempBMap,Emotion[Column+NumColumns*Row+1],FaceRect,LoclStdRect,srcCopy,NIL);
				END;
		END;
  error:=FSClose(refnum);
END;}
{*************************************************************************}
PROCEDURE LabelRect(WhichRect: Rect; WhichString: Str255; Border: Boolean);
VAR
  TempInt1,TempInt2:   Integer;
BEGIN
  FillRect(WhichRect,white);
	TempInt1:=((WhichRect.right-WhichRect.left) div 2)+WhichRect.left;
	TempInt2:=StringWidth(WhichString);
	MoveTo(TempInt1-(TempInt2 div 2),WhichRect.top+20);
	DrawString(WhichString);
	IF Border THEN PenSize(3,3);
	FrameRect(WhichRect);
	PenNormal;
END;
{*************************************************************************}
PROCEDURE MakeOptions;
VAR
  i,j,k,x:   Integer;
	CharRect:  ARRAY[1..ConstChars] OF Rect;
	LengRect:  ARRAY[1..3] OF Rect;
	LevlRect:  ARRAY[1..3] OF Rect;
	ProceedRect:  Rect;
	ProceedFlag:  Boolean;
	LevlStr:   ARRAY[1..3] OF Str255;
	LengStr:   ARRAY[1..3] OF Str255;
	TempRect:  Rect;
{-------------------------------------------------------------------------}
PROCEDURE CenterText(TString: Str255; VertPos: Integer);
BEGIN
	MoveTo(256-StringWidth(TString) div 2,VertPos);
	DrawString(TString);
END;
{-------------------------------------------------------------------------}
BEGIN
	ShowCursor;
	FillRect(MyPort.portrect,white);
	TextSize(18);
	CenterText('OPTIONS',40);
	TextFont(0); TextSize(12);
	MoveTo(115,60); DrawString('Difficulty Level'); 
	MoveTo(299,60); DrawString('Length of Game');
	SetRect(LevlRect[1],131,70,191,100);
	SetRect(LevlRect[2],131,120,191,150);
	SetRect(LevlRect[3],131,170,191,200);
	SetRect(LengRect[1],321,70,381,100);
	SetRect(LengRect[2],321,120,381,150);
	SetRect(LengRect[3],321,170,381,200);
	SetRect(ProceedRect,226,300,286,330);
	LengStr[1]:='Short';
	LengStr[2]:='Medium';
	LengStr[3]:='Long';
	LevlStr[1]:='Easy';
	LevlStr[2]:='Medium';
	LevlStr[3]:='Hard';
	LabelRect(LengRect[1],LengStr[1],TRUE);
	LabelRect(LengRect[2],LengStr[2],FALSE);
	LabelRect(LengRect[3],LengStr[3],FALSE);
	LabelRect(LevlRect[1],LevlStr[1],TRUE);
	LabelRect(LevlRect[2],LevlStr[2],FALSE);
	LabelRect(LevlRect[3],LevlStr[3],FALSE);
	LabelRect(ProceedRect,'Proceed',FALSE);
	CenterText('WARNING!',230);
	CenterText('Persons who play this game',250);
	CenterText('without reading the rules and the novella',270);
	CenterText('are wasting their time!',290);
	InitCursor;
	ProceedFlag:=FALSE;
  REPEAT
	  SystemTask;
    IF GetNextEvent(everyEvent,myEvent) THEN
		  BEGIN
				IF myEvent.what=KeyDown THEN
					BEGIN
						IF BitAnd(myEvent.message,CharCodeMask)=13 THEN
							BEGIN
								InvertRect(ProceedRect);
								MyWait(10);
								InvertRect(ProceedRect);
								ProceedFlag:=TRUE;
								NarratOn:=FALSE;
								StoryDelay:=ExpDelay;
								SoundOn:=FALSE;
							END;
					END;
				IF myEvent.what=mouseDown THEN
					BEGIN
					 MousePt:=myEvent.where;
					 FOR i:=1 TO 3 DO
						 BEGIN
							 IF PtInRect(MousePt,LevlRect[i]) & RectHit(LevlRect[i]) THEN
								 BEGIN
									 LabelRect(LevlRect[Level],LevlStr[Level],FALSE);
									 Level:=i;
									 LabelRect(LevlRect[Level],LevlStr[Level],TRUE);
								 END;
						 END;
					 FOR i:=1 TO 3 DO
						 BEGIN
							 IF PtInRect(MousePt,LengRect[i]) & RectHit(LengRect[i]) THEN
								 BEGIN
									 LabelRect(LengRect[GameLeng],LengStr[GameLeng],FALSE);
									 GameLeng:=i;
									 LabelRect(LengRect[GameLeng],LengStr[GameLeng],TRUE);
								END;
						 END;
					 IF PtInRect(MousePt,ProceedRect) THEN
						 IF RectHit(ProceedRect) THEN
							 BEGIN
								 ProceedFlag:=TRUE;
								 NarratOn:=(BitAND(MyEvent.modifiers,ShiftKey)=0);
							END;
					END;
			END;
  UNTIL ProceedFlag;
END;
{********************************************************************************}
PROCEDURE InitSPtrs;
VAR
  i,x:	 Integer;
  Amp,Delta,z:	 Integer;
  Amp2,Delta2,z2:   Integer;
  RampMode:    Boolean;
  LengLim,TimeCnt,RampCnt:     Integer;
BEGIN
  CombatHndl:=NewHandle(30000);
  HLock(CombatHndl);
  CombatPtr:=CombatHndl^;
  CbFFPtr:=FFSynthPtr(CombatPtr);
  CbFFPtr^.mode:=FFMode;
  CbFFPtr^.count:=FixRatio(1,4);
  Amp:=0;
  Delta:=225;
  z:=0;
  Amp2:=0;
  Delta2:=10;
  z2:=0;
  x:=1;
  RampMode:=FALSE;
  RampCnt:=10;
  LengLim:=400;
  TimeCnt:=0;
  FOR i:=0 TO 29600 DO
    BEGIN
      Amp:=Amp+Delta;
      IF Amp>255 THEN
        BEGIN
          Amp:=511-Amp;
          Delta:=-Delta;
          z:=z+1;
          IF z>16 THEN BEGIN z:=0; Delta:=Delta+1; END;
        END;
      IF Amp<0 THEN
        BEGIN
          Amp:=-Amp;
          Delta:=-Delta;
          z:=z+1;
          IF z>16 THEN BEGIN z:=0; Delta:=Delta-1; END;
        END;

      TimeCnt:=TimeCnt+1;
      Amp2:=Amp2+Delta2;
      IF Amp2>255 THEN
        BEGIN
          Amp2:=511-Amp2;
          Delta2:=-Delta2;
          IF TimeCnt>LengLim THEN
            BEGIN
              TimeCnt:=0;
              RampMode:=NOT RampMode;
              IF RampMode THEN
                BEGIN
                  RampCnt:=RampCnt+1;
                  IF RampCnt>252 THEN RampCnt:=252;
                  Delta2:=-RampCnt;
                END
              ELSE Delta2:=-10;
            END;
          IF RampMode THEN
            BEGIN
              Delta2:=Delta2-1;
              IF Delta2<-252 THEN Delta2:=-252;
            END;
        END;
      IF Amp2<0 THEN
        BEGIN
          Amp2:=-Amp2;
          Delta2:=-Delta2;
        END;

      CbFFPtr^.wavebytes[i]:=3*(Amp2 div 4)+(Amp div 4);
    END;
  HUnlock(CombatHndl);
END;
{*************************************************************************}
PROCEDURE Titles;
VAR
  GasBMap1,GasBMap2,GasBMap3,GasBMap4:  BitMap;
  GasRect1,GasRect2,GasRect3,GasRect4:  Rect;
  GasBits1:	ARRAY[1..4096] OF Integer;
  GasBits2:	ARRAY[1..3136] OF Integer;
  GasBits3:	ARRAY[1..2304] OF Integer;
  GasBits4:	ARRAY[1..1600] OF Integer;
  TestRect:	Rect;
	TString:  Str255;
	Junk:			Integer;
	Message,Count:	Integer;
{-------------------------------------------------------------------------}
PROCEDURE ReadTitle(TitleName: Str255);
CONST
  headerSize = 512;
  BufSize = 512;
  srcBlocks = 8;
TYPE
  diskBlock = packed array [1..512] OF QDbyte;
VAR
  scanline:		Integer;
  error:		OSErr;
  Count:		LongInt;
  RefNum:		Integer;
  srcSize:    	Integer;
  showRect,lineRect:	Rect;
  srcBuf:		      	ARRAY [1..srcBlocks] OF diskBlock;
  dstBMap:				BitMap;
  dstBits:		      	packed array [1..72] of byte;
  srcPtr,dstPtr:	Ptr;
  WDrefNum:	Integer;
  volNamePtr:	StringPtr;
BEGIN
	dstBMap.rowBytes:=64;
	dstBMap.baseAddr:=@dstBits;
	SetRect(dstBMap.bounds,0,0,512,1);
	dstPtr:=pointer(dstBMap.baseAddr);
	RefNum:=YourOpen(TitleName);
	Count:=headerSize;
	error:=FSRead(RefNum,Count,@srcBuf);
	srcSize:=srcBlocks*512;
	Count:=srcSize;
	error:=FSRead(refNum,Count,@srcBuf);
	Count:=Count-512;
	srcPtr:=@srcBuf;
	SetRect(showRect,0,0,512,1);
	SetRect(lineRect,0,0,512,1);
	FOR Scanline:=1 to 256 DO
		BEGIN
			UnpackBits(srcPtr,dstPtr,72);
			CopyBits(dstBMap,GasBMap1,lineRect,showRect,srcCopy,NIL);
			dstPtr:=pointer(dstBMap.baseAddr);
			OffsetRect(showRect,0,1);
			IF ORD(srcPtr)>(ORD(@srcBuf)+srcSize-512) THEN
				BEGIN
					srcBuf[1]:=srcBuf[srcBlocks];
					error:=FSRead(refNum,Count,@srcBuf[2]);
					srcPtr:=pointer(ord(srcPtr)+512-srcSize);
				END;
		END;
	error:=FSClose(RefNum);
END;
{------------------------------------------------------------------------}
PROCEDURE ReDrawStars;
BEGIN
  PenPat(white);
  PenSize(2,2);
  MoveTo(47,61); LineTo(47,61);
  MoveTo(123,79); LineTo(123,79);
  MoveTo(315,290); LineTo(315,290);
  MoveTo(227,169); LineTo(227,169);
  MoveTo(500,46); LineTo(500,46);
  MoveTo(421,306); LineTo(421,306);
  MoveTo(357,255); LineTo(357,255);
  MoveTo(236,117); LineTo(236,117);
  MoveTo(189,204); LineTo(189,204);
  MoveTo(312,166); LineTo(312,166);
  MoveTo(420,16); LineTo(420,16);
  PenNormal;
END;
{------------------------------------------------------------------------}
PROCEDURE Zoomlet(j: Integer; Backwards: Boolean);
VAR 
  i,x,y:	Integer;
BEGIN
	CASE j OF
		1: BEGIN i:=2; x:=52; y:=28; END;
		2: BEGIN i:=2; x:=53; y:=28; END;
		3: BEGIN i:=3; x:=54; y:=28; END;
		4: BEGIN i:=3; x:=55; y:=28; END;
		5: BEGIN i:=4;; x:=57; y:=28; END;
		6: BEGIN i:=5; x:=59; y:=28; END;
		7: BEGIN i:=6; x:=61; y:=28; END;
		8: BEGIN i:=7; x:=64; y:=28; END;
		9: BEGIN i:=8; x:=67; y:=29; END;
		10: BEGIN i:=10; x:=71; y:=30; END;
		11: BEGIN i:=12; x:=75; y:=32; END;
		12: BEGIN i:=14; x:=79; y:=35; END;
		13: BEGIN i:=16; x:=84; y:=38; END;
		14: BEGIN i:=20; x:=90; y:=42; END;
		15: BEGIN i:=24; x:=97; y:=46; END;
		16: BEGIN i:=28; x:=105; y:=51; END;
		17: BEGIN i:=32; x:=114; y:=56; END;
		18: BEGIN i:=40; x:=124; y:=62; END;
		19: BEGIN i:=48; x:=135; y:=70; END;
		20: BEGIN i:=56; x:=147; y:=80; END;
		21: BEGIN i:=64; x:=161; y:=92; END;
		22: BEGIN i:=80; x:=177; y:=108; END;
		23: BEGIN i:=96; x:=197; y:=127; END;
		24: BEGIN i:=112; x:=221; y:=151; END;
		25: BEGIN i:=128; x:=251; y:=181; END;
	END;
	IF Backwards THEN
		BEGIN
			x:=502-x;
			SetRect(TestRect,x-i-48,y-i,x-i,y+i+30);
			FillRect(TestRect,black);
			SetRect(TestRect,x-i,y+i,x+i,y+i+30);
			FillRect(TestRect,black);	
		END
	ELSE
		BEGIN	
			SetRect(TestRect,x-i-30,y-i-30,x-i,y+i);
			FillRect(TestRect,black);
			SetRect(TestRect,x-i,y-i-30,x+i,y-i);
			FillRect(TestRect,black);
		END;
	SetRect(TestRect,x-i,y-i,x+i,y+i);
	CASE ((j+3) mod 4) OF
		0: CopyBits(GasBMap1,ScreenBits,GasRect1,TestRect,SrcCopy,NIL);
		1: CopyBits(GasBMap4,ScreenBits,GasRect4,TestRect,SrcCopy,NIL);
		2: CopyBits(GasBMap3,ScreenBits,GasRect3,TestRect,SrcCopy,NIL);
		3: CopyBits(GasBMap2,ScreenBits,GasRect2,TestRect,SrcCopy,NIL);
	END;
	ReDrawStars;
END;
{------------------------------------------------------------------------}
PROCEDURE Zoom(ZoomOut: Boolean; Hat: Integer);
VAR
  i,j,x,y:	Integer;
	TempRect: Rect;
BEGIN
	CopyBits(GasBMap1,GasBMap2,GasRect1,GasRect2,SrcCopy,NIL);
	CopyBits(GasBMap1,GasBMap3,GasRect1,GasRect3,SrcCopy,NIL);
	CopyBits(GasBMap1,GasBMap4,GasRect1,GasRect4,SrcCopy,NIL);
	
	SetRect(TestRect,128,53,384,309);
	FOR j:=10 TO 25 DO Zoomlet(j,FALSE);
	CASE Hat OF
	  1: TString:='Lamina is their home...';
		2: TString:='Kira their abode...';
		3: TString:='Legacy of Siboot';
	END;
	TextFont(2);
	TextSize(24);
	x:=StringWidth(TString) div 2;
	MoveTo(256-x,320);
	TextMode(srcBic);
	DrawString(TString);
	TextMode(srcOr);
	CASE Hat OF
	  1: ReadWords;
		2: BEGIN InitSPtrs; MyWait(60); END;
		3: BEGIN
		    TextMode(srcBic);
				TString:='Trust and Betrayal';
				TextSize(36);
	      x:=StringWidth(TString) div 2;
	      MoveTo(256-x,50);
	      DrawString(TString);
	      TextSize(18);
				TString:='by Chris Crawford';
	      x:=StringWidth(TString) div 2;
	      MoveTo(256-x,340);
	      DrawString(TString);
	      TextMode(srcOr);
		    ReadFaces;
				ReadEmotions;
			 END;
	END;
	IF Hat<>3 THEN 
	  BEGIN
	    SetRect(TempRect,100,280,500,340);
	    FillRect(TempRect,black);
	  END;
	IF ZoomOut THEN FOR j:=25 DOWNTO 10 DO Zoomlet(j,TRUE);
END;
{------------------------------------------------------------------------}
BEGIN
  InitChar(1,'Vetvel','Jomkar',FALSE,0,0,0,0,0,0,0,0,0,'Asparuch');
  InitChar(2,'Kendra','Klast',FALSE,0,0,16,8,0,0,0,16,4,'Tervel');
  InitChar(3,'Gardbore','Frem',TRUE,12,4,8,16,4,12,16,4,0,'Sevar');
  InitChar(4,'Wiki','Ripi',TRUE,8,12,12,0,16,4,8,8,4,'Kormisos');
  InitChar(5,'Locksher','Lokweel',TRUE,12,16,0,8,4,8,16,4,12,'Bashee');
  InitChar(6,'Zubi','Srol',FALSE,4,8,8,0,16,4,12,16,16,'Teletz');
  InitChar(7,'Skordokott','Tayran',TRUE,16,10,4,8,16,16,0,0,8,'Flofftsikott');
	CharName[8]:='Chris Crawford';

	SetRect(GasRect1,0,0,512,342);
	FillRect(GasRect1,black);
	SetRect(GasRect1,0,0,256,256);
	SetRect(GasRect2,0,0,224,224);
	SetRect(GasRect3,0,0,192,192);
	SetRect(GasRect4,0,0,160,160);
	
	GasBMap1.rowBytes:=32;
	GasBMap1.baseAddr:=@GasBits1;
	GasBMap1.bounds:=GasRect1;
	GasBMap2.rowBytes:=28;
	GasBMap2.BaseAddr:=@GasBits2;
	GasBMap2.bounds:=GasRect2;
	GasBMap3.rowBytes:=24;
	GasBMap3.BaseAddr:=@GasBits3;
	GasBMap3.bounds:=GasRect3;
	GasBMap4.rowBytes:=20;
	GasBMap4.BaseAddr:=@GasBits4;
	GasBMap4.bounds:=GasRect4;
	HideCursor;
  SetRect(StdRect1,0,0,32,32);
  SetRect(StdRect2,0,0,48,48);
  SetRect(StdRect3,0,0,160,160);
	SetRect(StdRect4,0,0,96,96);
	ReadTitle(':TitlePics:Title1');
	Zoom(TRUE,1);
	ReadTitle(':TitlePics:Title3');
	Zoom(TRUE,2);
	ReadTitle(':TitlePics:Title4');	
	Zoom(FALSE,3);
	MyWait(60);
END;
{*************************************************************************}
END.